; magOutl.jss
include "hjconst.jsh"
include "hjglobal.jsh"
include "magic.jsh"

Void Function FocusChangedMagEvent (handle FocusWindow, handle PrevWindow)
;  This function is designed to handle all MAGic specific processing that must occur
;  when the focus changes.  The window handles of the previous and new windows
;  are passed to this function to aid in the analysis of the focus change.
Var String cwClass, Int nX, Int nY, Int bSuccess, Int nL, Int nR, Int nT, Int nB
; Test for the existance of MAGic.  If MAGic is not running, return without doing any further processing.
;If (!MagGetState ()) then Return EndIf
Let bSuccess = FALSE
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (cwClass == mWN_STV32) then
  Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_WORD)
  If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
  If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_FIELD) EndIf
  Let nR = GetWindowRight (GetCurrentWindow ())
  If (nT <= 3) then Let nT = 0 Else Let nT = nT - 3 EndIf
  If (nL <= 3) then Let nL = 0 Else Let nL = nL - 3 EndIf
  MagSetFocusToRect (nL, nR, nT, nB + 1, MTO_GENERIC)
  Return
ElIf (cwClass == mWN_SPG) then
    GetLineRect (0, 0, nL, nR, nT, nB)
    MagSetFocusToRect (nL - 5, nR + 5, nT - 2, nB + 2, MTO_CARET)
    Return
ElIf ((cwClass == mWN_IEWin) && (GetItemRect (nX, nY, nL, nR, nT, nB, IT_CARET) == FALSE)) then
  Let nX = GetCursorCol ()
  Let nY = GetCursorRow ()
  Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT)
  If (!bSuccess) then GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
  If (bSuccess) then MagSetFocusToRect (nL, nR, nT, nB, MTO_CARET)
  Else MagSetFocusArea (nX, nY, 0, 0, 0, 0, 0) EndIf
Else MagSetFocusArea (nX, nY, 0, 0, 0, 0, 0) EndIf
EndFunction

Void Function FocusPointMovedMagEvent (int nX, int nY, int nOldX, int nOldY, int nUnit, int nDir, int nTimeElapsed)
;  This function first tests for the existance of MAGic.  If MAGic is running, it then determines
;  the current window type.  If the current window type is an edit Window, it calls
;  SetMagicFocusArea to set the focus to a region surrounding the cursor position.
;  Test to determine if there is an application specific setting in the jcf file to disable the JFW tracking engine.
; Test for the existance of MAGic.  If MAGic is not running, return without doing any further processing.
Var String cwClass, Int bSuccess, Int nL, Int nR, Int nT, Int nB
;If (!MagGetState ()) then Return EndIf
If (DidControlChange () == 1) then Return EndIf
If (GetCursorCol () - nX == 1) then Let nX = nX + 1 EndIf
Let bSuccess = FALSE
Let cwClass = GetWindowClass (GetCurrentWindow ())
If (cwClass == mWN_STV32) then
  Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_WORD)
  If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
  If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_FIELD) EndIf
  Let nR = GetWindowRight (GetCurrentWindow ())
  If (nT <= 3) then Let nT = 0 Else Let nT = nT - 3 EndIf
  If (nL <= 3) then Let nL = 0 Else Let nL = nL - 3 EndIf
  MagSetFocusToRect (nL, nR, nT, nB + 1, MTO_GENERIC)
  Return
ElIf (cwClass == mWN_SPG) then
    GetLineRect (0, 0, nL, nR, nT, nB)
    MagSetFocusToRect (nL - 5, nR + 5, nT - 2, nB + 2, MTO_CARET)
    Return
ElIf ((cwClass == mWN_IEWin) && (GetItemRect (nX, nY, nL, nR, nT, nB, IT_CARET) == FALSE)) then
  Let nX = GetCursorCol ()
  Let nY = GetCursorRow ()
  Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT)
  If (!bSuccess) then GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
  If (bSuccess) then MagSetFocusToRect (nL, nR, nT, nB, MTO_CARET)
  Else MagSetFocusArea (nX, nY, nOldX, nOldY, nUnit, nDir, NTimeElapsed) EndIf
Else MagSetFocusArea (nX, nY, nOldX, nOldY, nUnit, nDir, NTimeElapsed) EndIf
EndFunction
